import json
with open('pretrained_models/figures/measures_proba_diff_experiments.json') as f:
    results = json.loads(f.read())
wn18rr_exps = [x for x in list(results.keys()) if "WN18RR" in x]
fb15k_237_exps = [x for x in list(results.keys()) if "FB15K-237" in x]
print("WN18RR experiments (all ROAR):")
for k in wn18rr_exps:
    print(f"Hits@1-Diff:{results[k]['metrics']['hits1_diff']}, MR-Diff:{results[k]['metrics']['mr_diff']}, MRR-Diff:{results[k]['metrics']['mrr_diff']}, Proba-Diff:{results[k]['metrics']['proba_diff']}")
print("FB15k-237 experiments (all mixed)")
for k in fb15k_237_exps:
    print(f"Hits@1-Diff:{results[k]['metrics']['hits1_diff']}, MR-Diff:{results[k]['metrics']['mr_diff']}, MRR-Diff:{results[k]['metrics']['mrr_diff']}, Proba-Diff:{results[k]['metrics']['proba_diff']}")
print("FB15k-237 experiments (all reversed ROAR with 2 most influential triples)")
fb15k_237_2_rev_exps = [x for x in list(results.keys()) if "FB15K-237" in x and '2_rev' in x]
for k in fb15k_237_2_rev_exps:
    print(f"Hits@1-Diff:{results[k]['metrics']['hits1_diff']}, MR-Diff:{results[k]['metrics']['mr_diff']}, MRR-Diff:{results[k]['metrics']['mrr_diff']}, Proba-Diff:{results[k]['metrics']['proba_diff']}")
print("FB15k-237 experiments (all reversed ROAR with all influential triples)")
fb15k_237_rev_exps = [x for x in set(fb15k_237_exps).difference(set([x for x in list(results.keys()) if "FB15K-237" in x and '2_rev' in x])) if "_rev" in x]
for k in fb15k_237_rev_exps:
    print(f"Hits@1-Diff:{results[k]['metrics']['hits1_diff']}, MR-Diff:{results[k]['metrics']['mr_diff']}, MRR-Diff:{results[k]['metrics']['mrr_diff']}, Proba-Diff:{results[k]['metrics']['proba_diff']}")
print("FB15k-237 experiments (ROAR)")
fb15k_237_roar_exps = [x for x in set(fb15k_237_exps).difference(set(fb15k_237_2_rev_exps).union(set(fb15k_237_rev_exps)))]
for k in fb15k_237_roar_exps:
    print(f"Hits@1-Diff:{results[k]['metrics']['hits1_diff']}, MR-Diff:{results[k]['metrics']['mr_diff']}, MRR-Diff:{results[k]['metrics']['mrr_diff']}, Proba-Diff:{results[k]['metrics']['proba_diff']}")
