# Copyright 2019-2023 The AmpliGraph Authors. All Rights Reserved.
#
# This file is Licensed under the Apache License, Version 2.0.
# A copy of the Licence is available in LICENCE, or at:
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
"""The module includes performance metrics for neural graph embeddings models,
along with model selection routines, negatives generation, and an
implementation of the learning-to-rank-based evaluation protocol
used in literature."""

from .metrics import hits_at_n_score, mr_score, mrr_score, rank_score
from .protocol import (
    filter_unseen_entities,
    select_best_model_ranking,
    train_test_split_no_unseen,
)
from .explainers_evaluation import (
        remove_triples,
        get_calibration_set,
        check_coverage,
        retrain_model,
        retraining_experiment,
        calculate_differences,
        evaluate_explainer
)

__all__ = [
    "mrr_score",
    "mr_score",
    "hits_at_n_score",
    "rank_score",
    "select_best_model_ranking",
    "train_test_split_no_unseen",
    "filter_unseen_entities",
    'remove_triples',
    'get_calibration_set',
    'check_coverage',
    'retrain_model',
    'retraining_experiment',
    'calculate_differences',
    'evaluate_explainer'
]
