Tutorials
=========

For a comprehensive theoretical and hands-on overview of KGE models and hands-on AmpliGraph, check out our tutorials:
[COLING-22 KGE4NLP Tutorial (Slides + Colab Notebook)](https://kge4nlp-coling22.github.io/) and [ECAI-20 Tutorial (Slides + Recording + Colab Notebook)](https://kge-tutorial-ecai2020.github.io/). 

The following Jupyter notebooks will guide you through the most important features of AmpliGraph:

+ [AmpliGraph basics](tutorials/AmpliGraphBasicsTutorial.md): training, saving and restoring a model, evaluating a model, 
discover new links, visualize embeddings. 
[[Jupyter notebook](https://github.com/Accenture/AmpliGraph/blob/master/docs/tutorials/AmpliGraphBasicsTutorial.ipynb)] 
[[Colab notebook](https://colab.research.google.com/drive/1rylqOnm992AdP9z1aW8metlKpPuBTRGD)]
+ [Link-based clustering and classification](tutorials/ClusteringAndClassificationWithEmbeddings.md): how to use the 
knowledge embeddings generated by a graph of international football matches in clustering and classification tasks. 
[[Jupyter notebook](https://github.com/Accenture/AmpliGraph/blob/master/docs/tutorials/ClusteringAndClassificationWithEmbeddings.ipynb)] 
[[Colab notebook](https://colab.research.google.com/drive/1QUphvcFvNsWyRZM_J5ahsLhEHJY4SjyS)]

Additional examples and code snippets are [available here](examples.md).


If you reuse materials presented in the tutorials, cite as:


```
@misc{kge4nlp_tutorial_coling22,
	title = {Knowledge Graph Embeddings for NLP: From Theory to Practice},
	url = {https://kge4nlp-coling22.github.io/},
    author= {Luca Costabello and
             Adrianna Janik and
             Eda Bayram and
             Sumit Pai},
	date = {2022-16-10},
    note = {COLING 2022 Tutorials}
}
```


```
@misc{kge_tutorial_ecai20,
	title = {Knowledge Graph Embeddings Tutorial: From Theory to Practice},
	url = {http://kge-tutorial-ecai-2020.github.io/},
    author= {Luca Costabello and
             Sumit Pai and
             Adrianna Janik and
             Nick McCarthy},
	shorttitle = {Knowledge Graph Embeddings Tutorial},
	date = {2020-09-04},
    note = {ECAI 2020 Tutorials}
}
```
