from scipy import optimize
import numpy as np
from  tqdm import tqdm
import random as random
from sklearn.linear_model import LinearRegression
import matplotlib.pyplot as plt
import pickle
import sys
from agents import User
from algorithms import NCSMD

if __name__ == "__main__":
    var1 = sys.argv[1]
    var2 = sys.argv[2]
    var3 = sys.argv[3]

    rho = int(var1)/100
    user = int(var2)
    repeat = int(var3)
    
    random.seed(repeat)
    np.random.seed(repeat)

    path = "/home/user/"
    d = 5
    radius = 10
    theta = np.random.randn(d, 1)
    theta /= np.linalg.norm(theta, axis=0)
    x_star = -theta
    corrupted = True
    n_iter = 100000

    mu = 0.1
    lmbd = 0.05

    eta = np.log(n_iter)**(0.5) / n_iter**(0.5 + rho)/2/d
    user_smd = User(theta = theta, V0 = 2*np.eye(d), corrupted = corrupted, rho = rho, n_iter = n_iter, method = "SMD", corruption_mode="LU")
    ncsmd = NCSMD(feature_dim = d, lmbd = lmbd, radius = radius, mu = mu, eta = eta, user = user_smd)
    ncsmd.simulate(n_iter, user_smd)
    with open(f"{path}/smd/result_{rho}_{user}_{repeat}.json", 'wb') as f:
        pickle.dump(ncsmd.regret, f)  
