#!/bin/bash

rhos=(0 10 15 20 25 30 35 40 45)
users=(0)
repeats=(0 1 2 3 4)
betas=(5 10 15 20 25) 

for rho in "${rhos[@]}"; do
	echo "Submitting job for arg1=$rho"
	for user in "${users[@]}"; do
		echo "Submitting job for arg2=$user"
		for repeat in "${repeats[@]}"; do
			echo "Submitting job for arg3=$repeat"
			for beta in "${betas[@]}"; do
				echo "Submitting job for arg4=$beta"
				sbatch --export=arg1="$rho",arg2="$user",arg3="$repeat",arg4="beta" tradeoff.cmd
		done
	done
done



