import sys
sys.path.insert(0, '../')
sys.path.insert(0, '../../')

import numpy as np
from network_designer.design_space.core.base import Model
from network_designer.design_space.nasbench201.network import Network
from network_designer.design_space.core.search_space import calc_graph_hash

class NB201LikeModel(Model):
    def __init__(self, adj=None, ops=None, arch=None, design_space=None, create=True):
        super().__init__(adj, ops, arch, design_space)
        
    def create(self):
        self.model = self.create_model_from_graph(self.adj, self.ops)
            
    def create_model_from_graph(self, adj, ops):
        o = ops.astype(int)
        a = adj.astype(int)
        self.hash = calc_graph_hash(a, o)
        return Network(C=self.design_space.init_channels, 
                             N=self.design_space.N_nodes, 
                             num_classes=self.design_space.n_classes, 
                             search_space=self.design_space.candidate_operations, 
                             adj_matrix=a, ops=o)
