# Official Implementation for "Generating Neural Network Architectures with Conditional Graph Normalizing Flows" in AutoML-23 Workshop Submission

## Prepare Virtual Enviroment

We have export all required package in `requirements.txt`, please use following commands on enviroment setting.

```
conda install --file requirements.txt
```

We also want a library to help us calculate zc-score

```
git clone git@gitlab.com:JuniperSling/zc-toolkit.git
```

You can install this package by

```
cd zc-toolkit
pip install . 
```

## Prepare preprocessed dataset

That preprocessed trainning dataset is located in [dataset](https://www.dropbox.com/scl/fo/k2h9qsclorc4gvxsn7gv5/h?dl=0&rlkey=punxrtmzv4s63tez31vyywdob)

You can download `nasbench201` and `nasbench101` dataset in the `experiments/` folder.

## Train G-VAE 

### Training with NASBench201 dataset

```
cd scripts
bash train_vgae_nb201.sh
```

### Training with NASBench101 dataset
```
cd scripts
bash train_vgae_nb101.sh
```

## Train CCNF
### Training with NASBench201 dataset

```
cd scripts
bash train_nf_nb201_zc.sh
```

### Training with NASBench101 dataset
```
cd scripts
bash train_nf_nb101_zc.sh
```

## Use Trained checkpoints in Notebook

In `notebook/` folder we have provided notebook that produce results and figure plot that we used in paper.  We also provide trained checkpoints in [ckpt](https://www.dropbox.com/scl/fo/k2h9qsclorc4gvxsn7gv5/h?dl=0&rlkey=punxrtmzv4s63tez31vyywdob).

You can downkoad checkpoints into `nasbench201` and `nasbench101` to use each notebooks.

Specifically, for `nb101_VGAE_emb_check.ipynb` and  `nb201_VGAE_emb_check.ipynb` we use them to generate latent embbeding plots in GVAE latent space.

While `nb201_exploit_with_best_condition.ipynb` and `nb101_exploit_with_best_condition.ipynb` is used to generate search space using CCNF based on best reference model from nb201 and nb101.

## Train Sampled Models 

If you have generated sampled search space and want to further train them, you can use following commands to train:

### Train NASbench201 model
```
cd network_designer/trainner/nasbench201/
bash train_sampled_201.sh
```


### Train NASbench101 model
```
cd network_designer/trainner/nasbench101/
bash train_sampled_101.sh
```

