# MRT for TD3

This code implements **MRT** for TD3 on MuJoCo environments.

## Setup Instructions

### 1. Create Virtual Environment

Create a new virtual environment with Python 3.9:

```bash
python3.9 -m venv mrt
source mrt/bin/activate 
```

### 2. Install Required Libraries

Install the necessary libraries using `pip`:

```bash
# Key library versions
pip install torch torchvision
pip install MuJoCo==2.3.3 Gym==0.25.0 imageio numpy==1.26
```

### 3. Run Experiment

Run the experiment with the specified environment (`HalfCheetah-v4`) and MRT configuration:

```bash
python main.py --seed 1 --env HalfCheetah-v4 --mrt --mrt_interval 250
```

## Notes

* `--mrt_interval 250`: Specifies the interval at which the MRT mechanism will be applied.
* You can modify the seed and environment as per your experimental setup.

