export CUDA_VISIBLE_DEVICES="0,1,2,3,4,5,6,7"

splits=('bvcc_test' 'nisqa_test_for' 'nisqa_test_livetalk' 'nisqa_test_p501' 'singmos_1w_test' 'somos_test' 'tmhint_qi_1w_test' 'vmc_track1' 'vmc_track2' 'vmc_track3')


for split in "${splits[@]}"; do
    echo "Evaluating split: $split"
    
    accelerate launch --num_processes=8 cloud_audio_new/eval/eval_audio_new.py \
    --model-path ckpts_cloud/7b-CLoud-merged-mse/hf \
    --dataset-path "datasets/dataset_test_new/test" \
    --save-path "infer_results/cloud_mse/${split}.json" \
    --split $split \
    --batch-size 4 > "log_eval/cloud_mse/${split}.log" 2>&1
    
    echo "Evaluation for $split completed, log saved to log_eval/cloud_mse/${split}.log"
done
