export CUDA_VISIBLE_DEVICES="0,1"

splits=('bvcc_test' 'nisqa_test_for' 'nisqa_test_livetalk' 'nisqa_test_p501' 'singmos_1w_test' 'somos_test' 'tmhint_qi_1w_test')

for split in "${splits[@]}"; do
    echo "Evaluating split: $split"
    
    accelerate launch --num_processes=2 cloud_audio_new/eval/eval_audio.py \
    --model-path ckpts_cloud/7b-CLoud-merged/hf \
    --dataset-path "datasets/dataset_test/test" \
    --split $split \
    --batch-size 2 > "logs_cloud_eval/eval_new/${split}.log" 2>&1
    
    echo "Evaluation for $split completed, log saved to logs_cloud_eval/eval_new/${split}.log"
done
