export CUDA_VISIBLE_DEVICES=0,1,2,3,4,5,6,7
export NPROC_PER_NODE=8

OUTPUT_DIR="ckpts/sft_ckpts/critic-sft-merged-new"
MODEL_PATH=""
TRAIN_DATASET="data/sft_train_merged_new.jsonl"

swift sft \
    --model "$MODEL_PATH" \
    --model_type qwen2_audio \
    --train_type full \
    --dataset "$TRAIN_DATASET" \
    --torch_dtype bfloat16 \
    --num_train_epochs 5 \
    --per_device_train_batch_size 8 \
    --per_device_eval_batch_size 8 \
    --learning_rate 1e-5 \
    --gradient_accumulation_steps 1 \
    --save_strategy epoch \
    --eval_strategy epoch \
    --save_total_limit 10 \
    --logging_steps 5 \
    --deepspeed zero2 \
    --output_dir "$OUTPUT_DIR" \
    --system 'You are a helpful assistant.' \
    --warmup_ratio 0.05 \
    --dataloader_num_workers 64 \
    --save_only_model True \
    &> logs/critic-sft-merged-new/sft_train_merged.log