import sys
sys.path.append('./')

import torch
import clip
from PIL import Image

device = "cuda" if torch.cuda.is_available() else "cpu"
model, preprocess = clip.load("RN50", device=device)

image = preprocess(Image.open("CLIP.png")).unsqueeze(0).to(device)
print(image.shape)



text = clip.tokenize(["a diagram", "a dog", "a cat"]).to(device)

with torch.no_grad():
    image_features = model.encode_image(image)
    text_features = model.encode_text(text)

    logits_per_image, logits_per_text = model(image, text)
    probs = logits_per_image.softmax(dim=-1).cpu().numpy()

print("logits_per_image : ", logits_per_image)
print("logits_per_text : ", logits_per_text)
print("Label probs:", probs)  # prints: [[0.9927937  0.00421068 0.00299572]]