# Anonymous source code for policy-driven attack

This folder includes anonymized source code for "Policy-Driven Attack: Learning to Query for Hard-label Black-box Adversarial Examples", which is submitted to ICLR 2021 for double blind review (paper id: 102).

This demo version only supports untargeted policy-driven attack on MNIST with the carlinet as the victim model (i.e., CNN victim in the paper).

The weights for pre-trained policy network is in ```output/policy-smtrain-inv-mnist-carlinet-untargeted-l2/2020-09-28_13-41-55-DgrgzXkj```, which was originally a complete pre-training experiment directory created by ```train_grad_model.py```, and all files except the binary weights are now removed to keep the anonymity. 

The following command could run our pda on MNIST to attack the carlinet victim under the untargetd setting:

```
./pda_mnist_carlinet_untargeted_l2.sh
```

The gpu device could be specified by the ```CUDA_VISIBLE_DEVICES``` environment variable.

Our code is tested on the following environment (probably also works on other environments without many changes):

* Ubuntu 16.04
* Python 3.5.2
* CUDA 9.0.176
* CUDNN 7501
* PyTorch 1.1.0
* torchvision 0.2.0
* numpy 1.16.0 
* dill 0.3.2

