import numpy as np

def select_from_scores(all_scores, selection="lex", elitism=False):
        selected = []
        if elitism:
            #add individual with highest score
            #print(f"SHAPE: {all_scores.shape}")
            #print(f"ARGMAX: {np.argmax(all_scores)}")
            selected.append(np.argmax(np.sum(all_scores, axis=1))) #elitism

        if selection == "lex":
            # do lexicase selection with epsilon
            x_median = np.median(all_scores, axis=1)
            # Calculate absolute deviation from median
            dev = abs(all_scores - x_median[:,None])
            mad = np.median(dev, axis=0) #we use the mad as epsilon

            #mad = np.zeros(all_scores.shape[1])

            # print(f"mad: {mad}")
            # print(f"all_scores: {all_scores.shape}")
            # print(f"pop scores: {np.sum(all_scores, axis=1)}")
            # print(f"all_scores max: {np.max(all_scores)}")
            # print(f"avg score: {np.mean(np.sum(all_scores, axis=1))}")

            for itr in range(
                #only start at 0 if not elitism
                int(elitism), all_scores.shape[0]
            ):  # , desc='selected', file=sys.stdout):
                num_features = all_scores.shape[1]
                features = np.arange(num_features)
                np.random.shuffle(features)
                pool = np.ones(all_scores.shape[0], dtype=bool)  # logical array if selected
                while len(features) != 0 and np.sum(pool) != 1:  # while we still have cases to use
                    feature = features[0]
                    features = features[1:]
                    
                    best = np.max(all_scores[pool, feature])
                    old_pool = pool
                    # print(f"old pool: {old_pool}")

                    # filter selected pop with this feature. If it filters everyone, skip
                    pool = np.logical_and(
                        pool, all_scores[:, feature] >= best - mad[feature],
                    )  

                sel = np.argmax(pool)
                selected.append(sel)
                #print(f"selected individual: {all_scores[sel]}")
                # print(f"selected individual's score: {np.sum(all_scores[sel])}")

        elif selection == "move":
            #assert that we have an archive of individuals
            #Assert that we have an achive of shape (x, n) that holds indices of objectives
            raise NotImplementedError

        elif selection == "tourn":
            agg_scores = np.sum(all_scores, axis=1)
            
            for itr in range(int(elitism), all_scores.shape[0]):
                #tournament selection of one individual
                parents = np.random.choice(np.arange(all_scores.shape[0]), (all_scores.shape[0] // 10,))
                best_parent = np.argmax(agg_scores[parents])
                selected.append(parents[best_parent])
        else:
            raise Exception("Invalid selection method")
        
        return selected