#!/bin/bash
sudo apt-get install ninja-build
# export TORCH_CUDA_ARCH_LIST='7.5'
gpu=0
prompt="An elephant skull"

echo "CUDA:$gpu, Prompt: $prompt"

filename=$(echo "$prompt" | sed 's/ /-/g')
n_particles=1
cd /huangzemin/lute/prolificdreamer
echo "current work dir: $(pwd)"


CUDA_VISIBLE_DEVICES=$gpu /huangzemin/niche/envs/edm/bin/python main.py \
--text "$prompt" --iters 25000 --lambda_entropy 10 --scale 7.5 --n_particles $n_particles --h 512  --w 512 \
--t5_iters 15000 --workspace exp-nerf-stage1/0805-samples

#------------------------------------------------------------------------------

prompt="An astronaut is riding a horse."
echo "CUDA:$gpu, Prompt: $prompt"
filename=$(echo "$prompt" | sed 's/ /-/g')
echo "current work dir: $(pwd)"


CUDA_VISIBLE_DEVICES=$gpu /huangzemin/niche/envs/edm/bin/python main.py \
--text "$prompt" --iters 25000 --lambda_entropy 10 --scale 7.5 --n_particles $n_particles --h 512  --w 512 \
--t5_iters 12500 --workspace exp-nerf-stage1/0805-samples

#------------------------------------------------------------------------------

prompt="A model of a house in Tudor style"
echo "CUDA:$gpu, Prompt: $prompt"
filename=$(echo "$prompt" | sed 's/ /-/g')
echo "current work dir: $(pwd)"


CUDA_VISIBLE_DEVICES=$gpu /huangzemin/niche/envs/edm/bin/python main.py \
--text "$prompt" --iters 25000 --lambda_entropy 10 --scale 7.5 --n_particles $n_particles --h 512  --w 512 \
--t5_iters 12500 --workspace exp-nerf-stage1/0805-samples


#------------------------------------------------------------------------------

prompt="A tarantula, highly detailed."
echo "CUDA:$gpu, Prompt: $prompt"
filename=$(echo "$prompt" | sed 's/ /-/g')
echo "current work dir: $(pwd)"


CUDA_VISIBLE_DEVICES=$gpu /huangzemin/niche/envs/edm/bin/python main.py \
--text "$prompt" --iters 25000 --lambda_entropy 10 --scale 7.5 --n_particles $n_particles --h 512  --w 512 \
--t5_iters 12500 --workspace exp-nerf-stage1/0805-samples
