#! /bin/bash
#SBATCH -o log/cactus.%j.out
#SBATCH --partition=GPUA800
#SBATCH --job-name=reverse
#SBATCH --ntasks=1
#SBATCH --gres=gpu:1
#SBATCH --qos=normal
#SBATCH --cpus-per-task=2
#SBATCH --time 100:00:00
#SBATCH --mem 24G
#SBATCH -x gpua800n23,gpua800n02,gpua800n15

source /gpfs/share/software/anaconda/3-2023.09-0/etc/profile.d/conda.sh
conda activate uni

gpu=0
n_particles=4

# prompt="A model of a house in Tudor style."
#prompt="A pirate ship in the sky." delete this
# prompt='A refined vase with artistic patterns.'
prompt='A small saguaro cactus planted in a clay pot.'

echo "CUDA:$gpu, Prompt: $prompt"
filename=$(echo "$prompt" | sed 's/ /-/g')
echo "current work dir: $(pwd)"


CUDA_VISIBLE_DEVICES=$gpu python main.py \
--text "$prompt" --iters 70000 --lambda_entropy 10 --scale 7.5 --seed 2002 --density_thresh 0.3 --n_particles $n_particles --h 512  --w 512 \
--t5_iters 12500 --workspace exp/p0+cfg7.5+cactus+n4+i70000-1/ --divergence "Forward-KL"

echo "done"

# # #------------------------------------------------------------------------------

# prompt="A cactus in a desert scene."

# echo "CUDA:$gpu, Prompt: $prompt"

# filename=$(echo "$prompt" | sed 's/ /-/g')

# echo "current work dir: $(pwd)"

# CUDA_VISIBLE_DEVICES=$gpu python -u main.py \
# --text "$prompt" --iters 25000 --seed 2024 --lambda_entropy 10 --scale 75 --n_particles $n_particles --h 512  --w 512 \
# --t5_iters 15000 --workspace exp4/nosim+reward5+cfg75+cactus+n4+seed2024/

# #------------------------------------------------------------------------------


# prompt="Portrait of a man who looks like a bulldog."
# echo "CUDA:$gpu, Prompt: $prompt"
# filename=$(echo "$prompt" | sed 's/ /-/g')
# echo "current work dir: $(pwd)"


# CUDA_VISIBLE_DEVICES=$gpu python main.py \
# --text "$prompt" --iters 15000 --lambda_entropy 10 --scale 7.5 --n_particles $n_particles --h 512  --w 512 \
# --t5_iters 12500 --workspace exp/exp-nerf-stage1-nowgt-factor-cfg_normnoise-reg05-nlatents/


# #------------------------------------------------------------------------------

# prompt="Sculpture made of flame, portrait, female."
# echo "CUDA:$gpu, Prompt: $prompt"
# filename=$(echo "$prompt" | sed 's/ /-/g')
# echo "current work dir: $(pwd)"


# CUDA_VISIBLE_DEVICES=$gpu python main.py \
# --text "$prompt" --iters 15000 --lambda_entropy 10 --scale 7.5 --n_particles $n_particles --h 512  --w 512 \
# --t5_iters 12500 --workspace exp/exp-nerf-stage1-nowgt-factor-cfg_normnoise-reg05-nlatents/


