#! /bin/bash
#SBATCH -o log/110-sim3d.%j.out
#SBATCH --partition=GPUA800
#SBATCH --job-name=sim_3d+
#SBATCH --ntasks=1
#SBATCH --gres=gpu:1
#SBATCH --qos=normal
#SBATCH --cpus-per-task=4
#SBATCH --time 100:00:00
#SBATCH --mem 24G
#SBATCH -x gpua800n23,gpua800n02,gpua800n15

source /gpfs/share/software/anaconda/3-2023.09-0/etc/profile.d/conda.sh
#conda activate sid_lsg
# conda activate zero123
conda activate reward

#sudo apt-get install ninja-build
# export TORCH_CUDA_ARCH_LIST='7.5'
gpu=0
prompt="A unicorn in a clearing. It has a single shining horn."

echo "CUDA:$gpu, Prompt: $prompt"

filename=$(echo "$prompt" | sed 's/ /-/g')
n_particles=1
#cd /huangzemin/lute/prolificdreamer
echo "current work dir: $(pwd)"


CUDA_VISIBLE_DEVICES=$gpu python main.py \
--text "$prompt" --iters 25000 --lambda_entropy 10 --scale 75 --n_particles $n_particles --h 512  --w 512 \
--t5_iters 15000 --workspace exp-rlhf-05/exp-nerf-stage1/

#------------------------------------------------------------------------------

# prompt="A half - masked rugged laboratory engineer man with cybernetic enhancements as seen from a distance."
# echo "CUDA:$gpu, Prompt: $prompt"
# filename=$(echo "$prompt" | sed 's/ /-/g')
# echo "current work dir: $(pwd)"


# CUDA_VISIBLE_DEVICES=$gpu python main.py \
# --text "$prompt" --iters 35000 --lambda_entropy 10 --scale 7.5 --n_particles $n_particles --h 512  --w 512 \
# --t5_iters 12500 --workspace exp-rlhf-05/exp-nerf-stage1/1110-samples

# #------------------------------------------------------------------------------

# prompt="Portrait of a man who looks like a bulldog."
# echo "CUDA:$gpu, Prompt: $prompt"
# filename=$(echo "$prompt" | sed 's/ /-/g')
# echo "current work dir: $(pwd)"


CUDA_VISIBLE_DEVICES=$gpu python main.py \
--text "$prompt" --iters 35000 --lambda_entropy 10 --scale 7.5 --n_particles $n_particles --h 512  --w 512 \
--t5_iters 12500 --workspace exp-rlhf-05/exp-nerf-stage1/


#------------------------------------------------------------------------------

prompt="Sculpture made of flame, portrait, female."
echo "CUDA:$gpu, Prompt: $prompt"
filename=$(echo "$prompt" | sed 's/ /-/g')
echo "current work dir: $(pwd)"


CUDA_VISIBLE_DEVICES=$gpu python main.py \
--text "$prompt" --iters 35000 --lambda_entropy 10 --scale 7.5 --n_particles $n_particles --h 512  --w 512 \
--t5_iters 12500 --workspace exp-rlhf-05/exp-nerf-stage1/


