#! /bin/bash
#SBATCH -o log1/225_genimg.%j.out
#SBATCH --partition=GPUA800
#SBATCH --job-name=gene_img
#SBATCH --ntasks=1
#SBATCH --gres=gpu:1
#SBATCH --qos=normal
#SBATCH --cpus-per-task=2
#SBATCH --time 100:00:00
#SBATCH --mem 24G
#SBATCH -x gpua800n23,gpua800n02,gpua800n15

source /gpfs/share/software/anaconda/3-2023.09-0/etc/profile.d/conda.sh
conda activate reward

gpu=0
n_particles=1

prompt="A baby bunny sitting on top of a stack of pancakes."

echo "CUDA:$gpu, Prompt: $prompt"

filename=$(echo "$prompt" | sed 's/ /-/g')
# echo "current work dir: $(pwd)"

# CUDA_VISIBLE_DEVICES=$gpu python main.py --text "$prompt" --iters 25000 --lambda_entropy 10 --scale 7.5 --density_thresh 0.2 --n_particles $n_particles --h 512  --w 512 --t5_iters 5000 --workspace exp_cfg/cfg7.5_mouse_stage1/

# # recent_ckpt=$(find exp_all/new_allstage_pickscore100_sim_cfg4.5_notebook_c7.5_stage1 -type d -name "*$filename*" -exec ls -d {}/checkpoints \; | head -n 1)

# # CUDA_VISIBLE_DEVICES=$gpu python main.py --text "$prompt" --iters 15000 --scale 100 --dmtet --mesh_idx 0  --init_ckpt $recent_ckpt/best_df_ep0250.pth --normal True --sds True --density_thresh 0.13 --lambda_normal 5000 --workspace exp_all/new_allstage_pickscore100_sim_cfg7.5_notebook_c100_stage2/

# # recent_ckpt=$(find exp_all/new_allstage_pickscore100_sim_cfg7.5_notebook_c100_stage2 -type d -name "*$filename*" -exec ls -d {}/checkpoints \; | head -n 1)

CUDA_VISIBLE_DEVICES=$gpu python main.py --text "$prompt" --iters 30000 --scale 7.5 --dmtet --mesh_idx 0  --init_ckpt /gpfs/share/home/2301111469/sim_3d_reward/exp7/new_allstage_pickscore100_sim_cfg4.5_cutebunny_c7.5_stage3/2025-01-27-scale-7.5-lr-0.001-albedo-le-10-render-512-cube-sd-2.1-5000-finetune-dth-0.2-tet-256/checkpoints/best_df_ep0300.pth --density_thresh 0.3 --finetune True --workspace img/bunny_pancakes_2/
# # #------------------------------------------------------------------------------