#! /bin/bash
#SBATCH -o log1/306-sim3d+.%j.out
#SBATCH --partition=GPUA800
#SBATCH --job-name=sim_3d+
#SBATCH --ntasks=1
#SBATCH --gres=gpu:1
#SBATCH --qos=normal
#SBATCH --cpus-per-task=2
#SBATCH --time 100:00:00
#SBATCH --mem 24G
#SBATCH -x gpua800n23,gpua800n02,gpua800n15

source /gpfs/share/software/anaconda/3-2023.09-0/etc/profile.d/conda.sh
conda activate test

gpu=0
n_particles=4

prompt="A high quality photo of an ice cream sundae."

echo "CUDA:$gpu, Prompt: $prompt"

filename=$(echo "$prompt" | sed 's/ /-/g')
# echo "current work dir: $(pwd)"

# CUDA_VISIBLE_DEVICES=$gpu python main.py --text "$prompt" --iters 25000 --lambda_entropy 10 --scale 7.5 --seed 12138 --density_thresh 0.2 --n_particles $n_particles --h 512  --w 512 --t5_iters 5000 --workspace exp_4particles/ice_stage1/

recent_ckpt=$(find exp_4particles/sim+pickscore100+cfg50+icecream+n4+i40000 -type d -name "*$filename*" -exec ls -d {}/checkpoints \; | head -n 1)

CUDA_VISIBLE_DEVICES=$gpu python main.py --text "$prompt" --iters 15000 --scale 5 --dmtet --mesh_idx 2  --init_ckpt $recent_ckpt/best_df_ep0400.pth --normal True --sds True --density_thresh 0.2 --lambda_normal 0 --workspace exp_4particles/ice_stage2/

recent_ckpt=$(find exp_4particles/ice_stage2 -type d -name "*$filename*" -exec ls -d {}/checkpoints \; | head -n 1)

CUDA_VISIBLE_DEVICES=$gpu python main.py --text "$prompt" --iters 30000 --scale 7.5 --dmtet --mesh_idx 2  --init_ckpt $recent_ckpt/best_df_ep0150.pth --density_thresh 0.2 --finetune True --workspace exp_4particles/ice_stage3/
# # #------------------------------------------------------------------------------



# CUDA_VISIBLE_DEVICES=$gpu python main.py --text "$prompt" --iters 30000 --scale 7.5 --dmtet --mesh_idx 0  --init_ckpt "/gpfs/share/home/2301111469/sim_3d_reward/exp_teaser/cfg4.5_armchair_stage2/0-02-26-scale-100.0-lr-0.001-albedo-le-10-render-512-cube-sd-2.1-5000-sds-normal-dth-0.2-tet-256-lnorm-5000.0/checkpoints/best_df_ep0150.pth" --density_thresh 0.2 --finetune True --workspace exp_teaser/cfg4.5_armchair_stage3/

# CUDA_VISIBLE_DEVICES=$gpu python main.py --text "$prompt" --iters 25000 --lambda_entropy 0 --lambda_orient 0 --scale 4.5 --density_thresh 0.2 --n_particles $n_particles --h 512  --w 512 --t5_iters 5000 --workspace exp/4particles_nolambda_stage1/


