function [Wii, wflag] = connect_module2(Wi)
% 初始矩阵处理
[w1, w2] = size(Wi);
Wi = Wi(2:end, :);  % 移除第一行
[w1, w2] = size(Wi);  % 更新尺寸

% 初始化变量
plus = ones(1, w2);
Wii = zeros(w1, w2);
wflag = zeros(1, w2);
wmem = false(1, w2);  % 使用逻辑数组提高性能
cur = 1;

% 主循环：处理每个未访问的节点
for i = 1:w2
    if ~wmem(i)
        % 使用BFS查找连通分量
        queue = i;
        wmem(i) = true;
        component_nodes = i;  % 存储连通分量节点
        
        while ~isempty(queue)
            u = queue(1);
            queue(1) = [];
            
            % 向量化查找邻居节点
            neighbors = find(Wi(u, 1:w2) > 0.01 & ~wmem(1:w2));
            
            % 更新访问状态和队列
            wmem(neighbors) = true;
            queue = [queue, neighbors];
            component_nodes = [component_nodes, neighbors];
        end
        
        % 计算连通分量内的总边数（向量化）
        [row_idx, col_idx] = meshgrid(component_nodes, component_nodes);
        valid_edges = Wi(sub2ind([w1, w2], row_idx(:), col_idx(:))) > 0.01;
        total_edges = sum(valid_edges);
        
        % 标记连通分量并更新Wii
        wflag(component_nodes) = cur;
        
        % 向量化赋值（仅更新连通分量内的节点）
        [comp_rows, comp_cols] = meshgrid(component_nodes, component_nodes);
        linear_idx = sub2ind(size(Wii), comp_rows(:), comp_cols(:));
        Wii(linear_idx) = total_edges;
        
        cur = cur + 1;
    end
end

% 添加首行
Wii = [plus; Wii];
end