function Wii2 = connect_value(Wi, Wii, wflag)
% 初始矩阵处理
Wi = Wi(2:end, :);  % 移除第一行
Wii2 = Wii(2:end, :);  % 移除Wii的第一行
[w1, w2] = size(Wi);

% 创建连通分量标记矩阵（向量化替代嵌套循环）
flag_mat = (wflag' == wflag);  % w2 x w2 逻辑矩阵，标记相同连通分量

% 计算需要更新的值（向量化操作）
update_vals = Wii(1:w1, 1:w2) - abs(Wi);

% 仅更新相同连通分量的位置
Wii2(flag_mat) = update_vals(flag_mat);

% 添加首行
Wii2 = [ones(1, w2); Wii2];
end
    

