function nn = nnbp(nn)
    
    n = nn.n;
    sparsityError = 0;

    [mm,mmm] = size(nn.a{2}); 
    [ww,www] = size(nn.W{2});

    switch nn.output
        case 'sigm'
            d{n} = - nn.e .* (nn.a{n} .* (1 - nn.a{n}));
        case {'softmax','linear'}
            d{n} = - nn.e;
    end
    for i = (n - 1) : -1 : 2
        % Derivative of the activation function
        switch nn.activation_function 
            case 'sigm'
                d_act = nn.a{i}.*(1-nn.a{i});
            case 'tanh_opt'
                d_act = 1.7159 * 2/3 * (1 - 1/(1.7159)^2 * nn.a{i}.^2);
        end
        
        if(nn.nonSparsityPenalty>0)
            pi = repmat(nn.p{i}, size(nn.a{i}, 1), 1);
            sparsityError = [zeros(size(nn.a{i},1),1) nn.nonSparsityPenalty * (-nn.sparsityTarget ./ pi + (1 - nn.sparsityTarget) ./ (1 - pi))];
        end

        if i+1==n             
            d{i} = (d{i + 1} * nn.W{i} + sparsityError) .* d_act;
        end
        
        if i==2
            da1 = nn.a{i+1} .* (1 - nn.a{i+1});
              
            ww = nn.ww;

            vv1 = ww(:,1);
            vv2 = ww(:,2:end);
            vv2 = vv2';
            ww = [vv1,vv2];
            
            pp = d{i+1};
            pp = pp(:,2:end);

            for k = 1:mm 

                daa = da1(k,:);
                z_G = pp;
                options = optimset('TolFun',0.0001);

                alpha = nn.alpha;
                wii = nn.Wii;

                wc = ww(:,2:end);
                scc = tarjan(wc);

                mx = max(nn.wflag);
                [Wii1,Wii2] = size(nn.Wii);
                z = zeros(1, mmm-1);  % ?????z???????

                sucw = 1;
                tempsee = [];
                while sucw == 1
                    sucw = 0;
                    ppw = pp;
                    seew = find(sum(ww(:,2:end)) == 0);
                    seew = setdiff(seew,tempsee);

                    [seew1,seew2] = size(seew);

                    while seew2 > 0
                        fwIndices = seew;
                        tempsee = union(tempsee,fwIndices);

                        mw = zeros(1,www-1);
                        mw(fwIndices) = 1;
                        mww = mw;

                        whyw = size(mww);

                        ppw_gpu = gpuArray(ppw);
                        mww_gpu = gpuArray(mww);
                        ww_gpu = gpuArray(ww);

                        %ppw_gpu = ppw;
                        %mww_gpu = mww;
                        %ww_gpu = ww;

                        ppw_gpu = ppw_gpu.*mww_gpu*ww_gpu(:,2:end)';
                        ppw = gather(ppw_gpu);
                        %ppw = ppw_gpu;

                        [fw1,fw2] = size(fwIndices);

                        if fw2 > 0
                            rows = fwIndices(1, 1:fw2);
                            ww(rows, :) = 0;
                        end
        
                        seew = find(sum(ww(:,2:end)) == 0);
                        seew = setdiff(seew,tempsee);
                        [seew1,seew2] = size(seew);
                        sucw = 1;
                    end

                    ppw_trimmed = ppw(1, 1:(mmm-1));
                    z = z + ppw_trimmed;

                    [scc1, scc2] = size(scc);
             
                    sccflag = zeros(1,scc2);
      
                    wflag = zeros(1,www-1);
                    for scci = 1:scc2
                        scctemp = scc{scci};

                        wcwc = ww(:,2:end);
                        seewff = wcwc(scctemp,scctemp);

                        seews = sum(wcwc);
                        seewsf = seews(1,scctemp);

                        kan = seewsf-sum(seewff);
                        kankan = find(abs(kan) > 0.0001);
                               
                        if sum(seewsf-sum(seewff)) > 0.0001
                            continue
                        end
                          
                        scctempc = setdiff(scctemp,tempsee);
                        [scctempc1,scctempc2] = size(scctempc);
                        if scctempc2 > 0
                            sccflag(1,scci) = 1;
                        end


                        [scctemp1,scctemp2] = size(scctemp);

                        if scctemp2 > 0
                            indices = scctemp(1, 1:scctemp2);
                            wflag(1, indices) = scci;
                            Wii(indices, indices) = scctemp2;
                        end                        
                    end

                    mx = max(wflag);
                    zc = cell(1,mx);

                    parfor mi = 1:mx
                        if sccflag(1,mi) == 0 || length(scc{mi}) == 1
                            continue
                        end

                        sucw = 1;
                        mvec = [0];
                        mpp = [1];
                        mdaa = daa(1,1);
                        [pp1,pp2] = size(wflag);
    
                        mcol = [];
                        miol = [];
                        for mj = 1:pp2
                            if mi == wflag(1,mj)
                                if mi == 19
                                    disp('here');
                                end
                                mvec = [mvec,mj];
                                mpp = [mpp,pp(1,mj)];
                                mdaa = [mdaa,daa(1,mj+1)];
                                mcol = [mcol;ww(mj,1)];
                                miol = [miol,wii(mj,1)];
                            end
                        end

                         mvec(:,1) = [];
                         
                         [mc1, mc2] = size(mvec);
                         
                        try
                            if mc2 > 0
                                max_row = max(mvec(1, 1:mc2)) + 1;
                                max_col = max(mvec(1, 1:mc2)) + 1;
                                %{
                                if max_row > size(ww, 1) || max_col > size(ww, 2)
                                    error('ww???????????: ???[%d,%d], ???[%d,%d]', ...
                                        max_row, max_col, size(ww,1), size(ww,2));
                                end
                                
                                if max_row > size(wii, 1) || max_col > size(wii, 2)
                                    error('wii???????????: ???[%d,%d], ???[%d,%d]', ...
                                        max_row, max_col, size(wii,1), size(wii,2));
                                end
                                %}
                                
                                ww_rows = size(ww, 1);
                                wii_rows = size(wii, 1);
                                rows = mvec(1, 1:mc2);
                                cols = mvec(1, 1:mc2);
                                
                                row_vec = rows(:);
                                col_vec = cols(:);
                                row_mat = repmat(row_vec, 1, mc2);
                                col_mat = repmat(col_vec, 1, mc2)';
                                
                                ww_idx = (col_mat + 1 - 1)*ww_rows + row_mat;
                                wii_idx = (col_mat - 1)*wii_rows + (row_mat + 1);
                                
                                mww = ww(ww_idx);
                                mwii = wii(wii_idx);
                            else
                                mww = [];
                                mwii = [];
                            end
                        catch ME
                            fprintf('???????????: %s\n', ME.message);
                            fprintf('mc2 = %d, ???????: ww=[%d %d], wii=[%d %d]\n', ...
                                mc2, size(ww,1), size(ww,2), size(wii,1), size(wii,2));
                            rethrow(ME);
                        end
    
                         mww = [mcol, mww];
                         mwii = [miol; mwii];

                         mz_G = mpp(:,2:end);

                         mz = fsolve(@(xx)root8d(xx,mpp,mww,mdaa,alpha,mwii), mz_G, options);
                                
                         zc{mi} = mz;
                     end
                  
                    if mx > 0
                        mvec = cell(1, mx);
                        wflag_vec = wflag(1, :);
   
                        parfor mi = 1:mx
                            mvec{mi} = find(wflag_vec == mi);
                        end
                        
                        all_scc = cell(1, mx);
                        z_values = cell(1, mx);
                        z_indices = cell(1, mx);

                        parfor mi = 1:mx
                            current_mvec = mvec{mi};
                            mc2 = numel(current_mvec);
                            temppp = zc{mi};
                            temppp2 = numel(temppp);
                            
                            all_scc{mi} = scc{mi};
                            
                            if temppp2 > 0 && mc2 > 0
                                assign_len = min(mc2, temppp2);
                                z_values{mi} = temppp(1:assign_len);
                                z_indices{mi} = current_mvec(1:assign_len);
                            else
                                z_values{mi} = [];
                                z_indices{mi} = [];
                            end
                        end
                        
                        all_indices = [z_indices{:}];
                        all_values = [z_values{:}];
                        valid_idx = all_indices <= (mmm-1);
                        z(1, all_indices(valid_idx)) = all_values(valid_idx);
                        
                        tempsee = unique([all_scc{:}]);
                    end

                    for scci = 1:scc2
                        nodes = scc{scci}(:)';
                        if ~isempty(nodes)
                            ww(nodes, nodes) = 0;
                        end
                    end
                
                end

                disp(k);
                disp(i);

                d{i}(k,2:mmm) = z;
            end
        end
        
        if(nn.dropoutFraction>0)
            d{i} = d{i} .* [ones(size(d{i},1),1) nn.dropOutMask{i}];
        end

    end

    for i = 1 : (n - 1)
        if i+1==n
            nn.dW{i} = (d{i + 1}' * nn.a{i}) / size(d{i + 1}, 1);
        else
            if i== 1
                nn.dW{i} = (d{i + 1}(:,2:end)' * nn.a{i}) / size(d{i + 1}, 1); 
            else 
                if i == 2
                    if www > 1
                        A = nn.a{i+1};
                        D = d{i};
                        mm_val = size(A, 1);
                        
                        full_product = D(:, 2:end)' * A;
                        
                        correction = zeros(www-1, www);
                        for k = 2:www
                            correction(k-1, k) = D(:, k)' * A(:, k);
                        end
                        
                        dw1 = (full_product - correction) / mm_val;
                    end

                    dw = dw1;

                    if www > 1
                        rowsk = size(dw,1);
                        
                        start_idx = rowsk + 1;
                        end_idx = www * rowsk;
                        
                        dw(start_idx:(rows+1):end_idx) = 0;
                    end
                    
                    nn.dW{i} = dw;


                    metaWi = nn.Wii;
                    [mw1, mw2] = size(metaWi);
                    Wij = metaWi';

                    wii22 = nn.Wii22;
                    mmmd = nn.W{i};
                    mmmd(:,1) = [];
                    nnd = nn.dW{i};
                    nnd200 = nnd(:,2:end);
                    nnd1 = nnd(:,1);

                    nnd200 = nnd200 + 2 * alpha  .* ((wii22'*wii22)./nn.Wii66') .* mmmd; 
                    %nnd200 = nnd200 + 2 * alpha * mmmd;
                    nn.dW{i} = [nnd1,nnd200];
                end
            end
        end
    end
end
