function nn = nnff2(nn, x, y, l)
%NNFF performs a feedforward pass
% nn = nnff(nn, x, y) returns an neural network structure with updated
% layer activations, error and loss (nn.a, nn.e and nn.L)

    n = nn.n;
    nodesize = nn.size;
    m = size(x, 1);
    
    x = [ones(m,1) x];
    nn.a{1} = x;

    %feedforward pass
    for i = 2 : n-1
        switch nn.activation_function 
            case 'sigm'
                if i == 2 
                    nn.ww1 = nn.W{i - 1}';
                    nn.a{i} = nn.a{i - 1} * nn.ww1;
                end
                if i == 3
                    nn.a{i} = zeros(m,nodesize(1,2));

                    for k = 1:m
                        wwwww = nn.W{i - 1}(:,1);

                        wwww = nn.W{2}(:,2:end);
                        [wwww1,wwww2] = size(wwww);
                        
                        wwww(1:min(wwww1,wwww2)+1:end) = 0;
                        
                        sortedWeights = sort(abs(wwww(:)), 'descend');
                        [pppp1,pppp2] = size(sortedWeights);
                        threshold = sortedWeights(floor(numel(sortedWeights)*nn.top_k));
                        mask = abs(wwww) >= threshold;
                        ww = wwww .* mask;

                        ww = [wwwww,ww];
                        nn.ww = ww;
            
                        pp = nn.a{i - 1}(k,:);

                        [Wii, wflag] = connect_module2(abs(ww'));
                        nn.Wii = connect_value(abs(ww'), abs(Wii), wflag);

                        [Wii1,Wii2] = size(Wii);
                        Wii = Wii/(Wii1*Wii2);

                        nn.Wii = Wii;
                        nn.wflag = wflag;

                        z_G = pp(:,2:end);
                        options = optimset('TolFun',0.0001);

                        alpha = nn.alpha;
                        wii = nn.Wii;
                        Wii = zeros(Wii1,Wii2);

                        mx = max(wflag);

                        z = zeros(1,Wii2);
                        %zc = cell(1,mx);
                        
                        sucw = 1;
                        tempsee = [];

                        wc = ww(:,2:end);
                        scc = tarjan(wc);

                        randomOrder = randperm(length(scc));  
                        randomC = scc(randomOrder);
                        scc = randomC;

                        if l == 100
                            [wca1,wca2] = size(wc);
                            kkaa = zeros(wca1,wca2);
                            [scc1, scc2] = size(scc);
                            curss = 0;
                            for vi = 1:scc2
                                tscc = scc{vi};
                                [tscc1,tscc2] = size(tscc);
                                for vj = 1:tscc2
                                    for vk = 1:tscc2
                                        kkaa(vj+curss,vk+curss) = 1;
                                    end
                                end
                                curss = curss + tscc2;
                            end
                            imshow(1-kkaa);

                            disp('ok');
                        end
                        


                        [scc1, scc2] = size(scc);
                        
                        [wc11,wc22] = size(wc);
                        Wii22 = zeros(1,wc22);
             
                        nn.Wii = Wii;

                        for sccjj = 1:scc2
                           tempscc = scc{sccjj};
                           [tempscc1,tempscc2] = size(tempscc);
                           for scckk = 1:tempscc2
                               Wii22(1,tempscc(1,scckk)) = length(tempscc);
                           end
                        end


                        nn.Wii22 = Wii22;

                        Wii33 = nn.W{2};
                        Wii33(:,1) = [];

                        kWii66 = exp(-zscore(Wii33));

                        nn.Wii66 = kWii66;

                        curnum = 100;
                        while sucw == 1
                            curnum = curnum - 1;
                            %disp('here1');
                            %disp(curnum);

                            sucw = 0;
                            ppw = pp;
                            seew = find(sum(ww) == 0);
                            seew = setdiff(seew,tempsee);

                            [seew1,seew2] = size(seew);
                            
                            curnum2 = 100;
                            while seew2 > 0
                                curnum2 = curnum2 - 1;

                                fwIndices = seew;
                                tempsee = union(tempsee,fwIndices);
                                mw = zeros(1,wwww1+1);
                                mw(fwIndices) = 1;
                                mww = mw;

                                whyw = size(mww);

                                wii22 = nn.Wii22' * nn.Wii22;
                                nnd = ww(:,2:end);

                                ppw_gpu = gpuArray(ppw);
                                mww_gpu = gpuArray(mww);
                                ww_gpu = gpuArray(ww);
                                alpha_gpu = gpuArray(alpha);
                                wii22_gpu = gpuArray(wii22);
                                Wii66_gpu = gpuArray(nn.Wii66);
                                nnd_gpu = gpuArray(nnd);

                                %ppw_gpu = ppw;
                                %mww_gpu = mww;
                                %ww_gpu = ww;
                                %alpha_gpu = alpha;
                                %wii22_gpu = wii22;
                                %Wii66_gpu = nn.Wii66;
                                %nnd_gpu = nnd;

                                %ppw_gpu = ppw_gpu.*mww_gpu*ww_gpu' + alpha_gpu * sum(wii22_gpu' ./ Wii66_gpu' .* abs(nnd_gpu'));
                                ppw_gpu = ppw_gpu.*mww_gpu*ww_gpu' + alpha_gpu * sum(wii22_gpu' ./ Wii66_gpu' .* (nnd_gpu') .^ 2);
                                %ppw_gpu = ppw_gpu.*mww_gpu*ww_gpu' + alpha_gpu * (nnd_gpu') .^ 2;
                                ppw = gather(ppw_gpu);
                                %ppw = ppw_gpu;

                                ppw = [1,ppw];

                                [fw1,fw2] = size(fwIndices);

                                target_indices = fwIndices(1, 1:fw2);  
                                
                                valid_rows = target_indices(target_indices > 1) - 1;
                                
                                if ~isempty(valid_rows)
                                    unique_rows = unique(valid_rows);
                                    
                                    max_row = size(ww, 1);
                                    valid_indices = unique_rows(unique_rows <= max_row & unique_rows > 0);
                                    
                                    if ~isempty(valid_indices)
                                        ww(valid_indices, :) = 0;
                                    end
                                end
        
                                seew = find(sum(ww) == 0);
                                seew = setdiff(seew,tempsee);
                                [seew1,seew2] = size(seew);
                                sucw = 1;
                            end
                            fwIndices = seew;
                            tempsee = union(tempsee,fwIndices);

                            z = z + ppw(1,2:end);
    
                            wc = ww(:,2:end);
                            %scc = tarjan(wc);
                            [scc1, scc2] = size(scc);
             
                            sccflag = zeros(1,scc2);
                            wflag = zeros(1,wwww1);
                            for scci = 1:scc2
                                scctemp = scc{scci};

                                wcwc = ww(:,2:end);
                                seewff = wcwc(scctemp,scctemp);

                                seews = sum(wcwc);
                                seewsf = seews(1,scctemp);

                                kan = seewsf-sum(seewff);
                                kankan = find(abs(kan) > 0.0001);
                               
                                if sum(seewsf-sum(seewff)) > 0.0001
                                    continue
                                end
                          
                                scctempc = setdiff(scctemp,tempsee);
                                [scctempc1,scctempc2] = size(scctempc);
                                if scctempc2 > 0
                                    sccflag(1,scci) = 1;
                                end

                                [scctemp1,scctemp2] = size(scctemp);
                                %for sccj = 1:scctemp2
                                %    wflag(1,scctemp(1,sccj)) = scci;
                                %    for scck = 1:scctemp2
                                %        Wii(scctemp(1,sccj),scctemp(1,scck)) = log(scctemp2);
                                %    end
                                %end

                                idx = scctemp(1, 1:scctemp2);
                                
                                wflag(1, idx) = scci;
                                
                                Wii(idx, idx) = log(scctemp2);
                            end
                             
                            mx = max(wflag);
                            zc = cell(1,mx);

                            parfor mi = 1:mx
                                wii22 = nn.Wii22;
   
                                if sccflag(1,mi) == 0 || length(scc{mi}) == 1
                                    continue
                                end

                                sucw = 1;

                                mvec = [0];
                                mpp = [1];
                                [pp1,pp2] = size(wflag);
    
                                mcol = [];
                                miol = [];
                                for mj = 1:pp2
                                    if mi == wflag(1,mj)
                                        mvec = [mvec,mj];
                                        mpp = [mpp,pp(1,mj+1)];
                                        mcol = [mcol;ww(mj,1)];
                                        miol = [miol,wii(mj,1)];
                                    end
                                end
       
                                %mpp = [1,mpp];
                                mvec(:,1) = [];
                                %mpp(:,1) = [];
    
                                [mc1,mc2] = size(mvec);
                                mww = zeros(mc2,mc2);
                                mww6 = zeros(mc2,mc2);
                                mwii = zeros(mc2,mc2);
                              
                                %if mc2 == 1
                                %    continue
                                %end

                                ww6 = nn.Wii66;
                                for mj = 1:mc2
                                    for mk = 1:mc2
                                        mww(mj,mk) = ww(mvec(1,mj), mvec(1,mk)+1);
                                        mwii(mj,mk) = wii(mvec(1,mj)+1, mvec(1,mk));
                                        mww6(mj,mk) = ww6(mvec(1,mj), mvec(1,mk));
                                    end
                                end
    
                                mww = [mcol, mww];
                                mwii = [miol; mwii];

                                
                                for mj = 1:pp2
                                    if mi == wflag(1,mj)
                                        mwiii = wii22(1,mj);
                                    end
                                end

                                mz_G = mpp(:,2:end);
                                mpp_gpu = gpuArray(mpp);
                                mww_gpu = gpuArray(mww);
                                alpha_gpu = gpuArray(alpha);
                                mwiii_gpu = gpuArray(mwiii);
                                mww6_gpu = gpuArray(mww6);

                                %mpp_gpu = mpp;
                                %mww_gpu = mww;
                                %alpha_gpu = alpha;
                                %mwiii_gpu = mwiii;
                                %mww6_gpu = mww6;
                                mz_G_gpu = mz_G;
                                options_gpu = options;
                                
                                %mz = fsolve(@(xx)root7d(xx,mpp_gpu,mww_gpu,alpha_gpu,mwiii_gpu,mww6_gpu), mz_G_gpu, options_gpu);
                                mz = fsolve(@(xx)root7d(xx,mpp,mww,alpha,mwiii,mww6), mz_G_gpu, options);
                                
                                %for mj = 1:mc2
                                %    z(1,mvec(1,mj)) = mz(1,mj);
                                %end
                                zc{mi} = mz;
                            end
    
                            for mi = 1:mx
                                mvec = [0];
                                [pp1,pp2] = size(wflag);
    
                                %for mj = 1:pp2
                                %    if mi == wflag(1,mj)
                                %        mvec = [mvec,mj];
                                %    end
                                %end

                                matches = find(wflag(1, 1:pp2) == mi);
                                mvec = [mvec, matches];

                                mvec(:,1) = [];
                                [mc1,mc2] = size(mvec);

                                temppp = zc{mi};
                                [temppp1,temppp2] = size(temppp);

                                if temppp2 == 0
                                    continue
                                end

                                mz = zc{mi}(1, 1:mc2);  
                                
                                z(1, mvec(1, 1:mc2)) = mz;

                                tempsee = union(tempsee,scc{mi}+1);
                            end

                            active_scc = find(sccflag(1, 1:scc2) == 1);  
                            
                            for kq = 1:numel(active_scc)
                                scci = active_scc(kq);
                                scctemp = scc{scci};
                                idxx = scctemp(1, :); 
                                
                                rowsx = idxx';
                                colsx = idxx + 1;
                                
                                [row_grid, col_grid] = meshgrid(rowsx, colsx);
                                valid = col_grid <= size(ww, 2); 
                                
                                linear_indices = sub2ind(size(ww), row_grid(valid), col_grid(valid));
                                ww(linear_indices) = 0;
                            end
                        end

                        nn.a{i}(k,:) = sigm(z);
                        disp('okokok');
                        disp(k);

                    end
                end

            case 'tanh_opt'
                disp('no tan')
        end
        
        %dropout
        if(nn.dropoutFraction > 0)
            if(nn.testing)
                nn.a{i} = nn.a{i}.*(1 - nn.dropoutFraction);
            else
                nn.dropOutMask{i} = (rand(-(nn.a{i}))>nn.dropoutFraction);
                nn.a{i} = nn.a{i}.*nn.dropOutMask{i};
            end
        end
        
        %calculate running exponential activations for use with sparsity
        if(nn.nonSparsityPenalty>0)
            nn.p{i} = 0.99 * nn.p{i} + 0.01 * mean(nn.a{i}, 1);
        end

        if i == 3
            nn.p{i - 1} = nn.a{i - 1};
            nn.a{i - 1} = [ones(m,1) nn.a{i}];
        end

        nn.a{i} = [ones(m,1) nn.a{i}];
    
    end
    switch nn.output 
        case 'sigm'
            nn.ww2 = nn.W{n - 1}';

            nn.a{n} = sigm(nn.a{n - 1} * nn.ww2);
        case 'linear'
            nn.a{n} = nn.a{n - 1} * nn.W{n - 1}';
        case 'softmax'
            nn.a{n} = nn.a{n - 1} * nn.W{n - 1}';
            nn.a{n} = exp(bsxfun(@minus, nn.a{n}, max(nn.a{n},[],2)));
            nn.a{n} = bsxfun(@rdivide, nn.a{n}, sum(nn.a{n}, 2)); 
    end

    %error and loss
    nn.e = y - nn.a{n};
    
    switch nn.output
        case {'sigm', 'linear'}
            nn.L = 1/2 * sum(sum(nn.e .^ 2)) / m; 
        case 'softmax'
            nn.L = -sum(sum(y .* log(nn.a{n}))) / m;
    end
end
