function F = root7d(x, p, w, alpha, mwiii, mww6)
    [s1, s2] = size(w);
    [p1, p2] = size(p);
    
    w_gpu = gpuArray(w);
    x_gpu = gpuArray(x);
    alpha_gpu = gpuArray(alpha);
    mwiii_gpu = gpuArray(mwiii);
    mww6_gpu = gpuArray(mww6);

    %w_gpu = w;
    %x_gpu = x;
    %alpha_gpu = alpha;
    %mwiii_gpu = mwiii;
    %mww6_gpu = mww6;
    
    sigm_x = 1 ./ (1 + exp(-x_gpu));

    F_gpu = zeros(s1, 1, 'like', w_gpu);

    for j = 1:s1
        k = 1:s1;  
        cond = (j ~= k) & (abs(w_gpu(j, k+1)) > 0.0001);  
        
        w_vals = w_gpu(j, k(cond)+1);  % w(j,k+1)
        sigm_vals = sigm_x(k(cond));   % sigm(x(1,k))
        mww6_vals = mww6_gpu(j, k(cond));  % mww6(j,k)
        
        part1 = w_vals .* sigm_vals;
        part2 = alpha_gpu .* (w_vals.^2) .* (mwiii_gpu^2 ./ mww6_vals);
        ss_gpu = sum(part1 + part2);  
        
        ss_gpu = ss_gpu + w_gpu(j, 1);  
        F_gpu(j) = x_gpu(j) - ss_gpu - p(1, j+1);  
    end
    
    F = gather(F_gpu);
    %F = F_gpu;
end
