function F = root8d(x, p, w, a, alpha, Wii)
    [s1, s2] = size(w);
    [p1, p2] = size(p);
    
    w_gpu = gpuArray(w);       
    x_gpu = gpuArray(x);      
    a_gpu = gpuArray(a);      

    %w_gpu = w;      
    %x_gpu = x;      
    %a_gpu = a;     

    F_gpu = zeros(s1, 1, 'like', w_gpu);
    
    for j = 1:s1
        k = 1:s1;

        cond = (j ~= k) & (abs(w_gpu(j, k+1)) > 0.0001);
        
        w_vals = w_gpu(j, k(cond) + 1);  % w(j,k+1)
        x_vals = x_gpu(k(cond));         % x(1,k)
        a_vals = a_gpu(k(cond) + 1);     % a(1,k+1)
        
        ss_gpu = sum(w_vals .* x_vals .* a_vals);
        
        F_gpu(j) = x_gpu(j) - ss_gpu - p(1, j+1);  
    end

    F = gather(F_gpu);
    %F = F_gpu;
end
    