function sccs = tarjanSCC(adjMatrix)
    % Tarjan 算法寻找有向图的强连通分量
    % 输入: adjMatrix - 邻接矩阵表示的有向图
    % 输出: sccs - 强连通分量列表，每个分量是一个节点索引的向量

    n = size(adjMatrix, 1); % 节点数量
    index = 0; % 访问顺序计数器
    indices = zeros(1, n); % 访问顺序数组
    lowlink = zeros(1, n); % 低点值数组
    onStack = false(1, n); % 栈状态数组
    stack = []; % 栈
    sccs = {}; % 强连通分量列表

    for i = 1:n
        if indices(i) == 0
            tarjanHelper(i, adjMatrix, index, indices, lowlink, onStack, stack, sccs);
        end
    end
end
