% 确保 MATLAB 支持 GPU
if ~canUseGPU()
    error('GPU 不可用');
end

% 初始化 GPU 数据
N = 1000;
%A = gpuArray.rand(N); % 创建一个随机矩阵并存储在 GPU 上
%B = gpuArray.rand(N); % 创建另一个随机矩阵并存储在 GPU 上

AA = rand(N);
BB = rand(N);

A = gpuArray(AA);
B = gpuArray(BB);

% 使用 parfor 在 GPU 上执行并行计算
parfor i = 1:N
    C(:, i) = A(:, i) + B(:, i); % 对每一列进行加法操作
end

% 将结果从 GPU 转移到 CPU
C = gather(C);