import './ReportOptions.css'

export default function ReportOptions({ options, onChange }) {
  const handleChange = (e) => {
    const { name, value, type, checked } = e.target
    onChange({
      ...options,
      [name]: type === 'checkbox' ? checked : value
    })
  }

  return (
    <div className="report-options">
      <h4>Report Options</h4>
      <div className="options-grid">
        <label>
          <input
            type="checkbox"
            name="includeTrends"
            checked={options.includeTrends}
            onChange={handleChange}
          />
          Include Market Trends
        </label>
        
        <label>
          <input
            type="checkbox"
            name="includeFinancials"
            checked={options.includeFinancials}
            onChange={handleChange}
          />
          Include Financial Data
        </label>
        
        <label>
          <input
            type="checkbox"
            name="includeRecommendations"
            checked={options.includeRecommendations}
            onChange={handleChange}
          />
          Include Recommendations
        </label>
        
        <label>
          Time Range:
          <select
            name="timeRange"
            value={options.timeRange}
            onChange={handleChange}
          >
            <option value="1m">1 Month</option>
            <option value="3m">3 Months</option>
            <option value="6m">6 Months</option>
            <option value="1y">1 Year</option>
            <option value="5y">5 Years</option>
          </select>
        </label>
      </div>
    </div>
  )
}
