import { useState } from 'react'
import './StockSearch.css'

export default function StockSearch({ onSearch }) {
  const [symbol, setSymbol] = useState('')

  const handleSubmit = (e) => {
    e.preventDefault()
    if (symbol.trim()) {
      onSearch(symbol.trim().toUpperCase())
    }
  }

  return (
    <form onSubmit={handleSubmit} className="stock-search">
      <input
        type="text"
        value={symbol}
        onChange={(e) => setSymbol(e.target.value)}
        placeholder="Enter stock symbol (e.g. AAPL)"
        required
      />
      <button type="submit">Search</button>
    </form>
  )
}
