import React, { useState } from 'react'
import styled from 'styled-components'
import MapView from './components/MapView'
import Dashboard from './components/Dashboard'
import Sidebar from './components/Sidebar'

const AppContainer = styled.div`
  display: grid;
  grid-template-columns: 300px 1fr;
  height: 100vh;
`

const MainContent = styled.div`
  display: grid;
  grid-template-rows: 1fr 1fr;
  gap: 20px;
  padding: 20px;
`

function App() {
  const [selectedAreas, setSelectedAreas] = useState([])
  const [dataType, setDataType] = useState('demographics')

  return (
    <AppContainer>
      <Sidebar 
        selectedAreas={selectedAreas}
        setSelectedAreas={setSelectedAreas}
        dataType={dataType}
        setDataType={setDataType}
      />
      <MainContent>
        <MapView 
          selectedAreas={selectedAreas}
          setSelectedAreas={setSelectedAreas}
        />
        <Dashboard 
          selectedAreas={selectedAreas}
          dataType={dataType}
        />
      </MainContent>
    </AppContainer>
  )
}

export default App
