import React from 'react'
import { Responsive, WidthProvider } from 'react-grid-layout'
import styled from 'styled-components'
import { Bar, Pie, Line } from 'react-chartjs-2'
import { Chart, registerables } from 'chart.js'
import { forestGreen } from '../theme'

Chart.register(...registerables)

const ResponsiveGrid = WidthProvider(Responsive)

const DashboardContainer = styled.div`
  background: white;
  border-radius: 8px;
  padding: 20px;
  box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
`

const ChartContainer = styled.div`
  background: white;
  padding: 10px;
  border-radius: 4px;
  border: 1px solid #eee;
`

const Dashboard = ({ selectedAreas, dataType }) => {
  const layout = [
    { i: 'a', x: 0, y: 0, w: 6, h: 2 },
    { i: 'b', x: 6, y: 0, w: 6, h: 2 },
    { i: 'c', x: 0, y: 2, w: 12, h: 2 }
  ]

  // Sample data - replace with real API calls
  const getChartData = () => {
    const labels = selectedAreas.map(area => area.name)
    const data = selectedAreas.map(() => Math.floor(Math.random() * 100))
    
    return {
      labels,
      datasets: [{
        label: dataType,
        data,
        backgroundColor: forestGreen,
        borderColor: '#000',
        borderWidth: 1
      }]
    }
  }

  return (
    <DashboardContainer>
      <ResponsiveGrid
        className="layout"
        layouts={{ lg: layout }}
        breakpoints={{ lg: 1200 }}
        cols={{ lg: 12 }}
        rowHeight={100}
      >
        <ChartContainer key="a">
          <Bar data={getChartData()} />
        </ChartContainer>
        <ChartContainer key="b">
          <Pie data={getChartData()} />
        </ChartContainer>
        <ChartContainer key="c">
          <Line data={getChartData()} />
        </ChartContainer>
      </ResponsiveGrid>
    </DashboardContainer>
  )
}

export default Dashboard
