import React from 'react'
import styled from 'styled-components'
import { FiHome, FiDollarSign, FiAlertTriangle } from 'react-icons/fi'
import { forestGreen } from '../theme'

const SidebarContainer = styled.div`
  background: white;
  padding: 20px;
  box-shadow: 2px 0 10px rgba(0, 0, 0, 0.1);
`

const DataTypeButton = styled.button`
  display: flex;
  align-items: center;
  width: 100%;
  padding: 10px;
  margin-bottom: 10px;
  border: none;
  background: ${props => props.active ? forestGreen : '#eee'};
  color: ${props => props.active ? 'white' : '#333'};
  border-radius: 4px;
  cursor: pointer;
  transition: all 0.2s;

  &:hover {
    background: ${forestGreen};
    color: white;
  }

  svg {
    margin-right: 10px;
  }
`

const Sidebar = ({ dataType, setDataType }) => {
  return (
    <SidebarContainer>
      <h2>Data Types</h2>
      <DataTypeButton 
        active={dataType === 'demographics'}
        onClick={() => setDataType('demographics')}
      >
        <FiHome /> Demographics
      </DataTypeButton>
      <DataTypeButton 
        active={dataType === 'economic'}
        onClick={() => setDataType('economic')}
      >
        <FiDollarSign /> Economic
      </DataTypeButton>
      <DataTypeButton 
        active={dataType === 'crime'}
        onClick={() => setDataType('crime')}
      >
        <FiAlertTriangle /> Crime
      </DataTypeButton>
    </SidebarContainer>
  )
}

export default Sidebar
