import { useState } from 'react'
import { BrowserRouter, Routes, Route, Navigate } from 'react-router-dom'
import BasePage from './pages/BasePage'
import RankingPage from './pages/RankingPage'
import StorePage from './pages/StorePage'
import TrainPage from './pages/TrainPage'
import WorkersPage from './pages/WorkersPage'
import UpgradesPage from './pages/UpgradesPage'
import BankPage from './pages/BankPage'
import MessagesPage from './pages/MessagesPage'
import ReportsPage from './pages/ReportsPage'
import RaceSelection from './components/RaceSelection'
import Navigation from './components/Navigation'
import { GameStateProvider } from './context/GameState'
import './App.css'

function App() {
  const [raceSelected, setRaceSelected] = useState(false)

  const handleRaceSelect = () => {
    setRaceSelected(true)
  }

  if (!raceSelected) {
    return <RaceSelection onSelect={handleRaceSelect} />
  }

  return (
    <GameStateProvider>
      <BrowserRouter>
        <div className="app-container">
          <Navigation />
          <Routes>
            <Route path="/" element={<BasePage />} />
            <Route path="/ranking" element={<RankingPage />} />
            <Route path="/store" element={<StorePage />} />
            <Route path="/train" element={<TrainPage />} />
            <Route path="/workers" element={<WorkersPage />} />
            <Route path="/upgrades" element={<UpgradesPage />} />
            <Route path="/bank" element={<BankPage />} />
            <Route path="/messages" element={<MessagesPage />} />
            <Route path="/reports" element={<ReportsPage />} />
            <Route path="*" element={<Navigate to="/" replace />} />
          </Routes>
        </div>
      </BrowserRouter>
    </GameStateProvider>
  )
}

export default App
