const express = require('express')
const cors = require('cors')
const sqlite3 = require('sqlite3').verbose()
const db = new sqlite3.Database('./travel.db')

const app = express()
app.use(cors())
app.use(express.json())

// Initialize database
db.serialize(() => {
  db.run(`CREATE TABLE IF NOT EXISTS users (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    name TEXT,
    email TEXT UNIQUE,
    password TEXT
  )`)

  db.run(`CREATE TABLE IF NOT EXISTS bookings (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    user_id INTEGER,
    type TEXT,
    details TEXT,
    cost REAL,
    date TEXT,
    FOREIGN KEY(user_id) REFERENCES users(id)
  )`)

  db.run(`CREATE TABLE IF NOT EXISTS reimbursements (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    booking_id INTEGER,
    user_id INTEGER,
    status TEXT DEFAULT 'pending',
    amount REAL,
    submission_date TEXT,
    approval_date TEXT,
    FOREIGN KEY(booking_id) REFERENCES bookings(id),
    FOREIGN KEY(user_id) REFERENCES users(id)
  )`)
})

// API Routes
app.post('/api/bookings', (req, res) => {
  const { userId, type, details, cost, date } = req.body
  db.run(
    'INSERT INTO bookings (user_id, type, details, cost, date) VALUES (?, ?, ?, ?, ?)',
    [userId, type, details, cost, date],
    function (err) {
      if (err) return res.status(500).json({ error: err.message })
      res.json({ id: this.lastID })
    }
  )
})

app.get('/api/reimbursements/:userId', (req, res) => {
  const { userId } = req.params
  db.all(
    `SELECT r.*, b.type, b.details, b.cost 
     FROM reimbursements r 
     JOIN bookings b ON r.booking_id = b.id 
     WHERE r.user_id = ?`,
    [userId],
    (err, rows) => {
      if (err) return res.status(500).json({ error: err.message })
      res.json(rows)
    }
  )
})

app.post('/api/reimbursements', (req, res) => {
  const { bookingId, userId, amount } = req.body
  const submissionDate = new Date().toISOString()
  db.run(
    'INSERT INTO reimbursements (booking_id, user_id, amount, submission_date) VALUES (?, ?, ?, ?)',
    [bookingId, userId, amount, submissionDate],
    function (err) {
      if (err) return res.status(500).json({ error: err.message })
      res.json({ id: this.lastID })
    }
  )
})

const PORT = 5000
app.listen(PORT, () => {
  console.log(`Server running on port ${PORT}`)
})
