import { BrowserRouter as Router, Routes, Route } from 'react-router-dom'
import { ThemeProvider, createTheme } from '@mui/material/styles'
import CssBaseline from '@mui/material/CssBaseline'
import Navbar from './components/Navbar'
import Dashboard from './pages/Dashboard'
import Bookings from './pages/Bookings'
import Reimbursements from './pages/Reimbursements'
import Reports from './pages/Reports'

const theme = createTheme({
  palette: {
    primary: {
      main: '#001f3f', // Navy
    },
    background: {
      default: '#ffffff', // White
    },
  },
})

function App() {
  return (
    <ThemeProvider theme={theme}>
      <CssBaseline />
      <Router>
        <Navbar />
        <Routes>
          <Route path="/" element={<Dashboard />} />
          <Route path="/bookings" element={<Bookings />} />
          <Route path="/reimbursements" element={<Reimbursements />} />
          <Route path="/reports" element={<Reports />} />
        </Routes>
      </Router>
    </ThemeProvider>
  )
}

export default App
