import { useState } from 'react'
import { Box, Button, TextField, Typography, Select, MenuItem, FormControl, InputLabel } from '@mui/material'

const BookingForm = ({ onSubmit }) => {
  const [booking, setBooking] = useState({
    type: 'flight',
    details: '',
    cost: '',
    date: ''
  })

  const handleSubmit = (e) => {
    e.preventDefault()
    onSubmit(booking)
  }

  return (
    <Box sx={{ p: 4, backgroundColor: 'white', borderRadius: 2, boxShadow: 3 }}>
      <Typography variant="h6" gutterBottom color="primary">
        New Travel Booking
      </Typography>
      <form onSubmit={handleSubmit}>
        <FormControl fullWidth margin="normal">
          <InputLabel>Booking Type</InputLabel>
          <Select
            value={booking.type}
            onChange={(e) => setBooking({...booking, type: e.target.value})}
            label="Booking Type"
          >
            <MenuItem value="flight">Flight</MenuItem>
            <MenuItem value="hotel">Hotel</MenuItem>
            <MenuItem value="train">Train</MenuItem>
          </Select>
        </FormControl>
        
        <TextField
          fullWidth
          margin="normal"
          label="Details"
          value={booking.details}
          onChange={(e) => setBooking({...booking, details: e.target.value})}
        />
        
        <TextField
          fullWidth
          margin="normal"
          label="Cost"
          type="number"
          value={booking.cost}
          onChange={(e) => setBooking({...booking, cost: e.target.value})}
        />
        
        <TextField
          fullWidth
          margin="normal"
          label="Date"
          type="date"
          InputLabelProps={{ shrink: true }}
          value={booking.date}
          onChange={(e) => setBooking({...booking, date: e.target.value})}
        />
        
        <Button 
          type="submit" 
          variant="contained" 
          color="primary" 
          sx={{ mt: 2 }}
        >
          Submit Booking
        </Button>
      </form>
    </Box>
  )
}

export default BookingForm
