import { AppBar, Toolbar, Typography, Button } from '@mui/material'
import { Link } from 'react-router-dom'

const Navbar = () => {
  return (
    <AppBar position="static" color="primary">
      <Toolbar>
        <Typography variant="h6" component="div" sx={{ flexGrow: 1 }}>
          Travel Reimbursement
        </Typography>
        <Button color="inherit" component={Link} to="/">
          Dashboard
        </Button>
        <Button color="inherit" component={Link} to="/bookings">
          Bookings
        </Button>
        <Button color="inherit" component={Link} to="/reimbursements">
          Reimbursements
        </Button>
      </Toolbar>
    </AppBar>
  )
}

export default Navbar
