import { useState } from 'react'
import { Box, Button, TextField, Typography, FormControl, InputLabel, Select, MenuItem } from '@mui/material'

const ReimbursementForm = ({ onSubmit }) => {
  const [reimbursement, setReimbursement] = useState({
    bookingId: '',
    amount: '',
    description: ''
  })

  const handleSubmit = (e) => {
    e.preventDefault()
    onSubmit(reimbursement)
  }

  return (
    <Box sx={{ p: 4, backgroundColor: 'white', borderRadius: 2, boxShadow: 3 }}>
      <Typography variant="h6" gutterBottom color="primary">
        New Reimbursement Request
      </Typography>
      <form onSubmit={handleSubmit}>
        <TextField
          fullWidth
          margin="normal"
          label="Booking ID"
          value={reimbursement.bookingId}
          onChange={(e) => setReimbursement({...reimbursement, bookingId: e.target.value})}
        />
        
        <TextField
          fullWidth
          margin="normal"
          label="Amount"
          type="number"
          value={reimbursement.amount}
          onChange={(e) => setReimbursement({...reimbursement, amount: e.target.value})}
        />
        
        <TextField
          fullWidth
          margin="normal"
          label="Description"
          multiline
          rows={4}
          value={reimbursement.description}
          onChange={(e) => setReimbursement({...reimbursement, description: e.target.value})}
        />
        
        <Button 
          type="submit" 
          variant="contained" 
          color="primary" 
          sx={{ mt: 2 }}
        >
          Submit Reimbursement
        </Button>
      </form>
    </Box>
  )
}

export default ReimbursementForm
