import { useState, useEffect } from 'react'
import { Box, Typography, Button } from '@mui/material'
import BookingForm from '../components/BookingForm'
import BookingList from '../components/BookingList'

const Bookings = () => {
  const [bookings, setBookings] = useState([])
  const [showForm, setShowForm] = useState(false)

  const handleSubmit = (newBooking) => {
    setBookings([...bookings, { ...newBooking, id: Date.now() }])
    setShowForm(false)
  }

  return (
    <Box sx={{ p: 4 }}>
      <Typography variant="h4" gutterBottom color="primary">
        Travel Bookings
      </Typography>
      {!showForm ? (
        <Button 
          variant="contained" 
          onClick={() => setShowForm(true)}
          sx={{ mb: 3 }}
        >
          Add New Booking
        </Button>
      ) : (
        <BookingForm onSubmit={handleSubmit} />
      )}
      <BookingList bookings={bookings} />
    </Box>
  )
}

export default Bookings
