import { useState } from 'react'
import { BrowserRouter as Router, Routes, Route } from 'react-router-dom'
import TeamManagement from './components/TeamManagement'
import GameSimulation from './components/GameSimulation'
import PlayerStats from './components/PlayerStats'
import Navbar from './components/Navbar'
import './App.css'

function App() {
  const [teams, setTeams] = useState([])
  const [players, setPlayers] = useState([])

  return (
    <Router>
      <div className="app-container">
        <Navbar />
        <Routes>
          <Route path="/" element={<TeamManagement teams={teams} setTeams={setTeams} />} />
          <Route path="/simulate" element={<GameSimulation teams={teams} />} />
          <Route path="/stats" element={<PlayerStats players={players} />} />
        </Routes>
      </div>
    </Router>
  )
}

export default App
