import { Link } from 'react-router-dom'

export default function Home() {
  return (
    <div className="container mx-auto p-4">
      <section className="py-12 text-center">
        <h1 className="text-4xl font-bold mb-6">Improve Your Credit Score Today</h1>
        <p className="text-xl mb-8">We help you dispute inaccuracies and improve your credit standing</p>
        <Link to="/contact" className="btn-primary inline-block">Get Started</Link>
      </section>

      <section className="py-8">
        <h2 className="text-2xl font-bold mb-4">Check Your Credit Score</h2>
        <div className="bg-white p-6 rounded-lg shadow-md">
          <p className="mb-4">Get a free estimate of your credit score:</p>
          <select className="input-field mb-4">
            <option>Select credit range</option>
            <option>300-579 (Poor)</option>
            <option>580-669 (Fair)</option>
            <option>670-739 (Good)</option>
            <option>740-799 (Very Good)</option>
            <option>800-850 (Excellent)</option>
          </select>
          <button className="btn-primary">Estimate My Score</button>
        </div>
      </section>
    </div>
  )
}
