export default function Services() {
  const services = [
    { name: 'Standard Cleaning', description: 'Basic cleaning of all rooms', price: '$100' },
    { name: 'Deep Cleaning', description: 'Thorough cleaning including hard-to-reach areas', price: '$200' },
    { name: 'Move-In/Move-Out', description: 'Complete cleaning for new or vacated homes', price: '$250' },
    { name: 'Recurring Service', description: 'Weekly or bi-weekly maintenance cleaning', price: '$80/visit' }
  ]

  return (
    <div className="services">
      <h1>Our Services</h1>
      <div className="service-list">
        {services.map((service, index) => (
          <div key={index} className="card">
            <h2>{service.name}</h2>
            <p>{service.description}</p>
            <p className="price">{service.price}</p>
          </div>
        ))}
      </div>
    </div>
  )
}
