import { Link } from 'react-router-dom'

export default function Home() {
  return (
    <main style={{ padding: '2rem 0', minHeight: '80vh' }}>
      <div className="container">
        <section style={{ 
          textAlign: 'center', 
          padding: '4rem 0',
          background: 'rgba(255,255,255,0.7)', 
          borderRadius: '10px',
          marginBottom: '3rem'
        }}>
          <h1 style={{ fontSize: '2.5rem', marginBottom: '1rem', color: '#b22222' }}>Transform Your Business with Our Solutions</h1>
          <p style={{ fontSize: '1.2rem', marginBottom: '2rem', maxWidth: '800px', margin: '0 auto 2rem' }}>
            We provide custom software development and staffing solutions tailored to your business needs.
          </p>
          <div style={{ display: 'flex', gap: '1rem', justifyContent: 'center' }}>
            <Link to="/services" className="btn">Our Services</Link>
            <Link to="/contact" className="btn" style={{ backgroundColor: 'transparent', border: '1px solid #b22222', color: '#b22222' }}>
              Contact Us
            </Link>
          </div>
        </section>

        <section style={{ marginBottom: '3rem' }}>
          <h2 style={{ textAlign: 'center', marginBottom: '2rem', color: '#b22222' }}>Why Choose Us?</h2>
          <div style={{ display: 'grid', gridTemplateColumns: 'repeat(auto-fit, minmax(300px, 1fr))', gap: '2rem' }}>
            <div style={{ background: 'rgba(255,255,255,0.7)', padding: '1.5rem', borderRadius: '10px' }}>
              <h3 style={{ color: '#b22222', marginBottom: '1rem' }}>Custom Solutions</h3>
              <p>We build software specifically designed for your business needs and workflows.</p>
            </div>
            <div style={{ background: 'rgba(255,255,255,0.7)', padding: '1.5rem', borderRadius: '10px' }}>
              <h3 style={{ color: '#b22222', marginBottom: '1rem' }}>Expert Staffing</h3>
              <p>Our vetted professionals integrate seamlessly with your teams to fill skill gaps.</p>
            </div>
            <div style={{ background: 'rgba(255,255,255,0.7)', padding: '1.5rem', borderRadius: '10px' }}>
              <h3 style={{ color: '#b22222', marginBottom: '1rem' }}>Proven Results</h3>
              <p>We've helped hundreds of businesses improve efficiency and reduce costs.</p>
            </div>
          </div>
        </section>
      </div>
    </main>
  )
}
