const plans = [
  {
    name: "Basic",
    price: "$19.99",
    features: ["5GB Data", "Unlimited Calls", "100 Texts"]
  },
  {
    name: "Standard",
    price: "$29.99",
    features: ["15GB Data", "Unlimited Calls", "Unlimited Texts"]
  },
  {
    name: "Premium",
    price: "$49.99",
    features: ["Unlimited Data", "Unlimited Calls", "Unlimited Texts", "5G Access"]
  }
]

export default function Plans() {
  return (
    <div>
      <h1>Our Service Plans</h1>
      <div style={{ display: 'flex', gap: '1rem', flexWrap: 'wrap' }}>
        {plans.map((plan, index) => (
          <div key={index} style={{ 
            backgroundColor: 'darkolivegreen', 
            padding: '1rem', 
            borderRadius: '8px',
            flex: '1',
            minWidth: '200px'
          }}>
            <h2>{plan.name}</h2>
            <h3>{plan.price}/month</h3>
            <ul>
              {plan.features.map((feature, i) => (
                <li key={i}>{feature}</li>
              ))}
            </ul>
            <button style={{ 
              backgroundColor: 'goldenrod', 
              border: 'none', 
              padding: '0.5rem 1rem', 
              borderRadius: '4px',
              marginTop: '1rem'
            }}>
              Select Plan
            </button>
          </div>
        ))}
      </div>
    </div>
  )
}
