import { BrowserRouter, Routes, Route } from 'react-router-dom'
import Dashboard from './pages/Dashboard'
import CompanyDetail from './pages/CompanyDetail'
import ConsolidatedReport from './pages/ConsolidatedReport'
import ComparisonTool from './pages/ComparisonTool'
import Navbar from './components/Navbar'

function App() {
  return (
    <BrowserRouter>
      <div className="app">
        <Navbar />
        <Routes>
          <Route path="/" element={<Dashboard />} />
          <Route path="/company/:id" element={<CompanyDetail />} />
          <Route path="/consolidated" element={<ConsolidatedReport />} />
          <Route path="/compare" element={<ComparisonTool />} />
        </Routes>
      </div>
    </BrowserRouter>
  )
}

export default App
