import React from 'react'

const CompanyInfo = ({ company }) => {
  return (
    <div className="p-4 rounded-lg shadow-md teal-border">
      <h2 className="text-xl font-semibold mb-4 teal-text">Company Information</h2>
      <div className="space-y-3">
        <div>
          <h3 className="font-medium teal-text">Basic Info</h3>
          <p>Founded: {company.founded}</p>
          <p>Industry: {company.industry}</p>
        </div>
        <div>
          <h3 className="font-medium teal-text">Financial Metrics</h3>
          <p>Revenue: ${company.revenue.toLocaleString()}</p>
          <p>Profit: ${company.profit.toLocaleString()}</p>
          <p>Expenses: ${company.expenses.toLocaleString()}</p>
          <p>Employees: {company.employees}</p>
        </div>
      </div>
    </div>
  )
}

export default CompanyInfo
