import React from 'react'
import { BarChart, Bar, XAxis, YAxis, CartesianGrid, Tooltip, Legend, ResponsiveContainer } from 'recharts'

const FinancialSummary = ({ companies }) => {
  return (
    <div className="p-4 rounded-lg shadow-md teal-border mb-6">
      <h2 className="text-xl font-semibold mb-4 teal-text">Financial Summary</h2>
      <div style={{ width: '100%', height: 400 }}>
        <ResponsiveContainer>
          <BarChart
            data={companies}
            margin={{
              top: 5,
              right: 30,
              left: 20,
              bottom: 5,
            }}
          >
            <CartesianGrid strokeDasharray="3 3" />
            <XAxis dataKey="name" />
            <YAxis />
            <Tooltip formatter={(value) => [`$${value.toLocaleString()}`, 'Amount']} />
            <Legend />
            <Bar dataKey="revenue" fill="#008080" name="Revenue" />
            <Bar dataKey="profit" fill="#004d4d" name="Profit" />
          </BarChart>
        </ResponsiveContainer>
      </div>
    </div>
  )
}

export default FinancialSummary
