import React from 'react'
import { Link } from 'react-router-dom'

const Navbar = () => {
  return (
    <nav className="teal-bg p-4 shadow-md">
      <div className="container mx-auto flex justify-between items-center">
        <Link to="/" className="text-xl font-bold text-white">Financial Dashboard</Link>
        <div className="flex space-x-4">
          <Link to="/" className="text-white hover:underline">Dashboard</Link>
          <Link to="/consolidated" className="text-white hover:underline">Consolidated</Link>
          <Link to="/compare" className="text-white hover:underline">Compare</Link>
        </div>
      </div>
    </nav>
  )
}

export default Navbar
