import React from 'react'
import { Link } from 'react-router-dom'

const QuickActions = () => {
  return (
    <div className="p-4 rounded-lg shadow-md teal-border mb-6">
      <h2 className="text-xl font-semibold mb-4 teal-text">Quick Actions</h2>
      <div className="flex flex-wrap gap-3">
        <Link 
          to="/consolidated" 
          className="px-4 py-2 bg-teal-600 text-white rounded hover:bg-teal-700 transition"
        >
          View Consolidated Report
        </Link>
        <Link 
          to="/compare" 
          className="px-4 py-2 bg-teal-600 text-white rounded hover:bg-teal-700 transition"
        >
          Compare Companies
        </Link>
        <button className="px-4 py-2 bg-teal-600 text-white rounded hover:bg-teal-700 transition">
          Export Data
        </button>
      </div>
    </div>
  )
}

export default QuickActions
