import React from 'react'
import { format } from 'date-fns'

const RecentActivities = () => {
  const activities = [
    { id: 1, company: 'Tech Corp', action: 'Updated financials', date: new Date(), amount: 50000 },
    { id: 2, company: 'Finance Inc', action: 'Added new report', date: new Date(Date.now() - 86400000), amount: 25000 },
    { id: 3, company: 'Retail Group', action: 'Processed transaction', date: new Date(Date.now() - 172800000), amount: 15000 }
  ]

  return (
    <div className="p-4 rounded-lg shadow-md teal-border">
      <h2 className="text-xl font-semibold mb-4 teal-text">Recent Activities</h2>
      <div className="space-y-3">
        {activities.map(activity => (
          <div key={activity.id} className="p-3 rounded border border-teal-100">
            <div className="flex justify-between">
              <span className="font-medium">{activity.company}</span>
              <span className="text-sm text-gray-500">{format(activity.date, 'MMM d, yyyy')}</span>
            </div>
            <p>{activity.action}</p>
            {activity.amount && <p className="text-teal-700">${activity.amount.toLocaleString()}</p>}
          </div>
        ))}
      </div>
    </div>
  )
}

export default RecentActivities
